	function assgn = hdlass(dest, src, class, varargin)
	%assgn = hdlass(dest, src[, class, ...])
	%assgn = hdlass(dest, src, 0[, destmod])
	%assgn = hdlass(dest, src, 1[, destmod, srcmod])
	%
	%Creates a hdlassignment2 structure
	%
	%Arguments:
	%  dest - assignment destination
	%  src - assignment source
	%  class - assignment class
	%    0: constant assignment
	%      numeric src: dest <= src
	%      string src: dest <= src
	%    1: signal assignment
	%      dest (with modifier destmod) <= src (with modifier srcmod)
	%    defaults to 0 if src is numeric, else 1
	
	%Copyright 2010 Anton Blad
	
	%This file is part of vhdlgen.
	
	%vhdlgen is free software: you can redistribute it and/or modify
	%it under the terms of the GNU General Public License as published by
	%the Free Software Foundation, either version 3 of the License, or
	%(at your option) any later version.
	
	%vhdlgen is distributed in the hope that it will be useful,
	%but WITHOUT ANY WARRANTY; without even the implied warranty of
	%MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	%GNU General Public License for more details.
	
	%You should have received a copy of the GNU General Public License
	%along with vhdlgen.  If not, see <http://www.gnu.org/licenses/>.
	
	if nargin < 3
		if isnumeric(src)
			class = 0;
		else
			class = 1;
		end
	end
	
	assgn.class = class;
	assgn.dest = dest;
	assgn.destmod = [];
	
	switch class
	case 0,
		if isnumeric(src)
			assgn.src = sprintf('%d', src);
		elseif ischar(src)
			assgn.src = sprintf('%s', src);
		else
			error('hdlass: invalid src for dest %s', dest);
		end
		if nargin > 3
			assgn.destmod = varargin{1};
		end
	case 1,
		assgn.src.ref = src;
		if nargin > 3
			assgn.destmod = varargin{1};
		end
		if nargin > 4
			assgn.src.mod = varargin{2};
		end
	otherwise,
		error('hdlass: invalid class %d for dest %s', class, dest);
	end
	
